using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Reflection;
using System.Windows.Forms;
using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{


		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Luke Meyer</Developer>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/30/2002</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>GUI 'About Box' form class</summary>

		#endregion

	public class FrmAboutBox : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.GroupBox grpAbout;
		private System.Windows.Forms.Label lblCopyright;
		private System.Windows.Forms.Label lblVersion;
		private System.Windows.Forms.Label lblVBECS;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Label lblCompiled;
		private System.Windows.Forms.GroupBox grpWarning;
		private System.Windows.Forms.Label lblWarning;
		private System.Windows.Forms.TextBox txtCompiled;
		private System.Windows.Forms.Label lblCLR;
		private System.Windows.Forms.TextBox txtCLR;
		private System.Windows.Forms.TextBox txtOS;
		private System.Windows.Forms.Label lblOS;
		private System.Windows.Forms.GroupBox grpFDAMessage;
		private System.Windows.Forms.Label lblFDAMessage;
		private System.Windows.Forms.Label lblEnvironment;
		private System.Windows.Forms.TextBox txtEnvironment;
		private System.Windows.Forms.Label lblBuild;
		private System.Windows.Forms.Label lblBuild2;
        private Label lblRevision;
        private Label label1;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

        ///<Developers>
        ///	<Developer>Denis Kozlov</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/7/2011</CreationDate>
        ///	<summary> FrmAboutBox class constructor. Call parameterless constructor and overwrites ProductName to input argument value.</summary>
        /// <returns>N/A</returns>
        public FrmAboutBox(string product_name)
        : this()
        {
            this.lblVBECS.Text = product_name;
            this.Text = "About " + product_name;	 
        }

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>4/30/2002</CreationDate>
		///	<summary> FrmAboutBox class constructor. Retrieves application version, compilation date, OS version and CLR version for display</summary>
		/// <returns>N/A</returns>
		public FrmAboutBox()
		{				 
			InitializeComponent();
			//
			SetComponentProperties();
			//
			this.lblVBECS.Text = this.ProductName;
			this.Text = "About " + this.ProductName;
			//CR 2834 - displaying both the version number and build number now.
			string sVersion = BOL.VbecsVersion.CurrentVersion.Substring(0, BOL.VbecsVersion.CurrentVersion.Length - 2);
			this.lblVersion.Text = string.Concat("Version ", sVersion);		//CR2465 - Version pulled from DB now, instead of config file

            var assembly = Assembly.GetExecutingAssembly();
            var fvi = FileVersionInfo.GetVersionInfo(assembly.Location);
            this.lblBuild.Text = string.Concat(fvi.FileVersion);		
            this.lblRevision.Text = string.Concat(BOL.VbecsVersion.CurrentRevision); //CR 3453
			this.txtCompiled.Text = Common.Utility.CompileDate;
			this.txtOS.Text = System.Environment.OSVersion.ToString();
			this.txtCLR.Text = System.Environment.Version.ToString();
			System.Data.SqlClient.SqlConnection sqlConn = new System.Data.SqlClient.SqlConnection(Common.VbecsConfig.Current.PrimaryDbConnectionString);
            //CR 3554
            if (sqlConn != null && sqlConn.DataSource != null && sqlConn.Database != null)
		        this.txtEnvironment.Text = string.Concat(sqlConn.DataSource.ToUpper(),".",sqlConn.Database.ToUpper());
		}

        /// <summary>
        /// Returns product name. By default it uses information from AssemblyInfo.cs file. 
        /// This property is virtual and may be overrided.
        /// </summary>
        new protected virtual string ProductName
        {
            get { return Application.ProductName; }
        }

		/// <summary>Clean up any resources being used</summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmAboutBox));
            this.btnOK = new System.Windows.Forms.Button();
            this.grpAbout = new System.Windows.Forms.GroupBox();
            this.lblRevision = new System.Windows.Forms.Label();
            this.label1 = new System.Windows.Forms.Label();
            this.lblBuild2 = new System.Windows.Forms.Label();
            this.lblBuild = new System.Windows.Forms.Label();
            this.txtEnvironment = new System.Windows.Forms.TextBox();
            this.lblEnvironment = new System.Windows.Forms.Label();
            this.txtCLR = new System.Windows.Forms.TextBox();
            this.txtCompiled = new System.Windows.Forms.TextBox();
            this.txtOS = new System.Windows.Forms.TextBox();
            this.lblCLR = new System.Windows.Forms.Label();
            this.lblOS = new System.Windows.Forms.Label();
            this.lblCopyright = new System.Windows.Forms.Label();
            this.lblCompiled = new System.Windows.Forms.Label();
            this.lblVersion = new System.Windows.Forms.Label();
            this.lblVBECS = new System.Windows.Forms.Label();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.grpWarning = new System.Windows.Forms.GroupBox();
            this.lblWarning = new System.Windows.Forms.Label();
            this.grpFDAMessage = new System.Windows.Forms.GroupBox();
            this.lblFDAMessage = new System.Windows.Forms.Label();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpAbout.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpWarning.SuspendLayout();
            this.grpFDAMessage.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(458, 30);
            this.vbecsLogo1.Title = "About";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 443);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.Location = new System.Drawing.Point(392, 423);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(64, 23);
            this.btnOK.TabIndex = 0;
            this.btnOK.Text = "&OK";
            // 
            // grpAbout
            // 
            this.grpAbout.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpAbout.Controls.Add(this.lblRevision);
            this.grpAbout.Controls.Add(this.label1);
            this.grpAbout.Controls.Add(this.lblBuild2);
            this.grpAbout.Controls.Add(this.lblBuild);
            this.grpAbout.Controls.Add(this.txtEnvironment);
            this.grpAbout.Controls.Add(this.lblEnvironment);
            this.grpAbout.Controls.Add(this.txtCLR);
            this.grpAbout.Controls.Add(this.txtCompiled);
            this.grpAbout.Controls.Add(this.txtOS);
            this.grpAbout.Controls.Add(this.lblCLR);
            this.grpAbout.Controls.Add(this.lblOS);
            this.grpAbout.Controls.Add(this.lblCopyright);
            this.grpAbout.Controls.Add(this.lblCompiled);
            this.grpAbout.Controls.Add(this.lblVersion);
            this.grpAbout.Controls.Add(this.lblVBECS);
            this.grpAbout.Location = new System.Drawing.Point(76, 34);
            this.grpAbout.Name = "grpAbout";
            this.grpAbout.Size = new System.Drawing.Size(380, 198);
            this.grpAbout.TabIndex = 10;
            this.grpAbout.TabStop = false;
            // 
            // lblRevision
            // 
            this.lblRevision.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblRevision.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblRevision.Location = new System.Drawing.Point(296, 179);
            this.lblRevision.Name = "lblRevision";
            this.lblRevision.Size = new System.Drawing.Size(62, 16);
            this.lblRevision.TabIndex = 24;
            this.lblRevision.Text = "A";
            this.lblRevision.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // label1
            // 
            this.label1.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.label1.Location = new System.Drawing.Point(240, 179);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(58, 16);
            this.label1.TabIndex = 23;
            this.label1.Text = "Revision";
            this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblBuild2
            // 
            this.lblBuild2.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblBuild2.Location = new System.Drawing.Point(8, 180);
            this.lblBuild2.Name = "lblBuild2";
            this.lblBuild2.Size = new System.Drawing.Size(80, 16);
            this.lblBuild2.TabIndex = 22;
            this.lblBuild2.Text = "Build";
            this.lblBuild2.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblBuild
            // 
            this.lblBuild.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblBuild.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblBuild.Location = new System.Drawing.Point(92, 180);
            this.lblBuild.Name = "lblBuild";
            this.lblBuild.Size = new System.Drawing.Size(140, 16);
            this.lblBuild.TabIndex = 21;
            this.lblBuild.Text = "0x0x.000x.xxxx.xxxxx";
            this.lblBuild.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtEnvironment
            // 
            this.txtEnvironment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtEnvironment.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.txtEnvironment.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtEnvironment.Location = new System.Drawing.Point(92, 160);
            this.txtEnvironment.Name = "txtEnvironment";
            this.txtEnvironment.ReadOnly = true;
            this.txtEnvironment.Size = new System.Drawing.Size(284, 14);
            this.txtEnvironment.TabIndex = 20;
            this.txtEnvironment.TabStop = false;
            // 
            // lblEnvironment
            // 
            this.lblEnvironment.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblEnvironment.Location = new System.Drawing.Point(8, 160);
            this.lblEnvironment.Name = "lblEnvironment";
            this.lblEnvironment.Size = new System.Drawing.Size(80, 16);
            this.lblEnvironment.TabIndex = 19;
            this.lblEnvironment.Text = "Environment";
            this.lblEnvironment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtCLR
            // 
            this.txtCLR.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCLR.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.txtCLR.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtCLR.Location = new System.Drawing.Point(92, 140);
            this.txtCLR.Name = "txtCLR";
            this.txtCLR.ReadOnly = true;
            this.txtCLR.Size = new System.Drawing.Size(284, 14);
            this.txtCLR.TabIndex = 18;
            this.txtCLR.TabStop = false;
            // 
            // txtCompiled
            // 
            this.txtCompiled.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtCompiled.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.txtCompiled.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtCompiled.Location = new System.Drawing.Point(92, 100);
            this.txtCompiled.Name = "txtCompiled";
            this.txtCompiled.ReadOnly = true;
            this.txtCompiled.Size = new System.Drawing.Size(284, 14);
            this.txtCompiled.TabIndex = 17;
            this.txtCompiled.TabStop = false;
            // 
            // txtOS
            // 
            this.txtOS.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtOS.BorderStyle = System.Windows.Forms.BorderStyle.None;
            this.txtOS.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.txtOS.Location = new System.Drawing.Point(92, 120);
            this.txtOS.Name = "txtOS";
            this.txtOS.ReadOnly = true;
            this.txtOS.Size = new System.Drawing.Size(284, 14);
            this.txtOS.TabIndex = 16;
            this.txtOS.TabStop = false;
            // 
            // lblCLR
            // 
            this.lblCLR.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblCLR.Location = new System.Drawing.Point(8, 140);
            this.lblCLR.Name = "lblCLR";
            this.lblCLR.Size = new System.Drawing.Size(80, 16);
            this.lblCLR.TabIndex = 14;
            this.lblCLR.Text = "CLR Version";
            this.lblCLR.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblOS
            // 
            this.lblOS.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblOS.Location = new System.Drawing.Point(8, 120);
            this.lblOS.Name = "lblOS";
            this.lblOS.Size = new System.Drawing.Size(80, 16);
            this.lblOS.TabIndex = 13;
            this.lblOS.Text = "OS Version";
            this.lblOS.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblCopyright
            // 
            this.lblCopyright.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblCopyright.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblCopyright.Location = new System.Drawing.Point(8, 80);
            this.lblCopyright.Name = "lblCopyright";
            this.lblCopyright.Size = new System.Drawing.Size(368, 16);
            this.lblCopyright.TabIndex = 12;
            this.lblCopyright.Text = "Developed by the Department of Veterans Affairs";
            this.lblCopyright.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblCompiled
            // 
            this.lblCompiled.Font = new System.Drawing.Font("Arial", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblCompiled.Location = new System.Drawing.Point(8, 100);
            this.lblCompiled.Name = "lblCompiled";
            this.lblCompiled.Size = new System.Drawing.Size(80, 16);
            this.lblCompiled.TabIndex = 11;
            this.lblCompiled.Text = "Compiled";
            this.lblCompiled.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblVersion
            // 
            this.lblVersion.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblVersion.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblVersion.Location = new System.Drawing.Point(280, 60);
            this.lblVersion.Name = "lblVersion";
            this.lblVersion.Size = new System.Drawing.Size(96, 16);
            this.lblVersion.TabIndex = 10;
            this.lblVersion.Text = "Version 1.0.0";
            this.lblVersion.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // lblVBECS
            // 
            this.lblVBECS.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblVBECS.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblVBECS.Location = new System.Drawing.Point(8, 14);
            this.lblVBECS.Name = "lblVBECS";
            this.lblVBECS.Size = new System.Drawing.Size(368, 40);
            this.lblVBECS.TabIndex = 9;
            this.lblVBECS.Text = "VistA Blood Establishment Computer Software (VBECS)";
            this.lblVBECS.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            // 
            // grpImage
            // 
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 34);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(68, 182);
            this.grpImage.TabIndex = 11;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(60, 164);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 3;
            this.pictureBox1.TabStop = false;
            // 
            // grpWarning
            // 
            this.grpWarning.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpWarning.Controls.Add(this.lblWarning);
            this.grpWarning.Location = new System.Drawing.Point(4, 236);
            this.grpWarning.Name = "grpWarning";
            this.grpWarning.Size = new System.Drawing.Size(452, 56);
            this.grpWarning.TabIndex = 12;
            this.grpWarning.TabStop = false;
            // 
            // lblWarning
            // 
            this.lblWarning.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblWarning.Location = new System.Drawing.Point(8, 16);
            this.lblWarning.Name = "lblWarning";
            this.lblWarning.Size = new System.Drawing.Size(440, 30);
            this.lblWarning.TabIndex = 0;
            this.lblWarning.Text = "Unauthorized access or misuse of this system and/or its data is a federal crime. " +
    "Use of all data shall be in accordance with VA policy on security and privacy.";
            // 
            // grpFDAMessage
            // 
            this.grpFDAMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpFDAMessage.Controls.Add(this.lblFDAMessage);
            this.grpFDAMessage.Location = new System.Drawing.Point(4, 300);
            this.grpFDAMessage.Name = "grpFDAMessage";
            this.grpFDAMessage.Size = new System.Drawing.Size(452, 108);
            this.grpFDAMessage.TabIndex = 13;
            this.grpFDAMessage.TabStop = false;
            // 
            // lblFDAMessage
            // 
            this.lblFDAMessage.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblFDAMessage.Location = new System.Drawing.Point(8, 12);
            this.lblFDAMessage.Name = "lblFDAMessage";
            this.lblFDAMessage.Size = new System.Drawing.Size(440, 92);
            this.lblFDAMessage.TabIndex = 0;
            this.lblFDAMessage.Text = resources.GetString("lblFDAMessage.Text");
            // 
            // FrmAboutBox
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(458, 457);
            this.Controls.Add(this.grpFDAMessage);
            this.Controls.Add(this.grpWarning);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.grpAbout);
            this.Controls.Add(this.btnOK);
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.MinimumSize = new System.Drawing.Size(466, 484);
            this.Name = "FrmAboutBox";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "About VBECS";
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.grpAbout, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.grpWarning, 0);
            this.Controls.SetChildIndex(this.grpFDAMessage, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpAbout.ResumeLayout(false);
            this.grpAbout.PerformLayout();
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpWarning.ResumeLayout(false);
            this.grpFDAMessage.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			vbecsLogo1.Title="About";
			
			this.RequiredFieldsLabel = false;
		}

	}
}